// Motor Drive Board TypeRTL Ver1.0 2022 Sample code.
// copyright RoBoTeNa Co., Ltd.

/*================== マクロ定義 ==================*/
#define LED_PIN        13
#define PUSHSW1_PIN     0
#define PUSHSW2_PIN     1
#define LINE1_PIN      A0
#define LINE2_PIN      A1
#define LINE3_PIN      A2
#define LINE4_PIN      A3
#define LINE5_PIN      A6
#define BATTVOLT_PIN   A7
#define ANGLE_PIN      A7
#define MARKER_L_PIN    7
#define MARKER_R_PIN    8
#define BUZZER_PIN      4
#define ENC_PIN         2
#define MOTOR_L_IN1     5
#define MOTOR_L_IN2     6
#define MOTOR_R_IN1     9
#define MOTOR_R_IN2    10

#define ON              1
#define OFF             0

/*================== 変数宣言 ==================*/
unsigned char Pattern = 0;            // 動作パターン（スタート前:0 ,モーター正回転:11, モーター逆回転:21）

/*================== 初期設定 ==================*/
void setup() {
  TCCR0B = (TCCR0B & 0b11111000) | 0x01;
  TCCR1B = (TCCR1B & 0b11111000) | 0x01;
  TCCR2B = (TCCR2B & 0b11111000) | 0x01;  

  Serial.begin(9600);       // set up Serial library at 9600 bps
  pinMode(LED_PIN, OUTPUT);
  pinMode(BUZZER_PIN, OUTPUT);
  
  pinMode(MOTOR_L_IN1, OUTPUT);
  pinMode(MOTOR_L_IN2, OUTPUT);
  pinMode(MOTOR_R_IN1, OUTPUT);
  pinMode(MOTOR_R_IN2, OUTPUT);
  
  // initialize the pushbutton pin as an input:
  pinMode(PUSHSW1_PIN, INPUT_PULLUP);
  pinMode(PUSHSW2_PIN, INPUT_PULLUP);

  // ブザー初期化
  Buzzer(OFF);

}

/*================== メインループ ==================*/
void loop() {

  switch( Pattern ) {
  case 0://スタート待ち
    MotorLR( 0, 0 );
    if( digitalRead(PUSHSW1_PIN) == 0 ){
      Pattern = 11;
    }
    if( digitalRead(PUSHSW2_PIN) == 0 ){
      Pattern = 21;
    }
    break;

  case 11:// モーター正回転テスト
    MotorLR(250, 250);
    break;

  case 21:// モーター逆回転テスト
    MotorLR(-255, -255);
    break;
    
  default:
    break;
  }
}

/************************************************************************
 モータ制御
************************************************************************/
void MotorLR(int l, int r){

    //最大値を超えない様にする処理
    if( l > 255 ){
      l = 255;
    }
    if( r > 255 ){
      r = 255;
    }
    if( l < -255 ){
      l = -255;
    }
    if( r < -255 ){
      r = -255;
    }

  //左モータ
    if (l == 0){
      digitalWrite(MOTOR_L_IN1, HIGH);
      digitalWrite(MOTOR_L_IN2, HIGH);
    } else if (l < 0){
      l = -l;
      l = 255-l;
      digitalWrite(MOTOR_L_IN1, HIGH);
      analogWrite(MOTOR_L_IN2, l);
    } else if (l > 0){
      l = 255-l;
      analogWrite(MOTOR_L_IN1, l);
      digitalWrite(MOTOR_L_IN2, HIGH);
    }
    
  //右モータ
    if (r == 0){
      digitalWrite(MOTOR_R_IN1, HIGH);
      digitalWrite(MOTOR_R_IN2, HIGH);
    } else if (r < 0){
      r = -r;
      r = 255-r;
      digitalWrite(MOTOR_R_IN1, HIGH);
      analogWrite(MOTOR_R_IN2, r);
    } else if (r > 0){
      r = 255-r;
      analogWrite(MOTOR_R_IN1, r);
      digitalWrite(MOTOR_R_IN2, HIGH);      
    }
}

/************************************************************************
 ブザー制御
************************************************************************/
void Buzzer(int beep){
   digitalWrite(BUZZER_PIN, beep);
}
